#############################################################################
# Modul pro implementace strategii
# --------------------------------------------------------
# Implementujte  nasledujici funkci, ktera spocte pozice kliknuti
# v minach tak, aby jejich pocet byl minimalni
# a nasledne je vypise do souboru "clicks.txt".
#
# Funkce dostava na vstup dvojrozmerne pole plane, kde k prvku pristupujete 
# spusobem: plane[radek][sloupec]. Jednotlive pozice obsahuji:
#    0 - prazdne policko
#    1 - mina
# Teda planek neobsahuje hodnoty o poctu sousednich min, ktere jsi musite
# dopocitat sami jestli je budete potrebovat.
#
# Svuj kod okomentujte a argumentujte proc vase reseni je urcite minimalni.
# V pripade ze existuje vicero reseni nezalezi na tom ktere vypisete.
# Vas algoritmus musi byt schopen problem vyresit obecne a mel by byt efektivni.
#
# Svuj kod muzete otestovat spustenim souboru run.py. Pro blizsi popis vid run.py.
#
# Dulezite:
# Nepouzivejte globalni promenne a vsechen vas kod napiste dovnitr funkce
# (tj. zadny kod se nesmi objevit mimo vyznacene oblasti).
#   $$$  Verim, ze tuto podminku jsem splnil - vsechny funkce se volaji z funkce
#         optimal_minesweeper a globalni promenne nepouzivam. $$$
############################################################################

import Queue

# vrati mnozstvi sousednich min policka daneho souradnicemi [x, y] na zaklde vstupni pole plane (viz zadani ulohy)
def getcnt(x, y, plane):
  ret = 0
  maxx = len(plane)-1
  maxy = len(plane[0])-1
  if x > 0: ret += plane[x-1][y]
  if y > 0: ret += plane[x][y-1]
  if x < maxx: ret += plane[x+1][y]
  if y < maxy: ret += plane[x][y+1]

  if (x < maxx) and (y < maxy): ret += plane[x+1][y+1]
  if (x > 0) and (y > 0): ret += plane[x-1][y-1]
  if (x < maxx) and (y > 0): ret += plane[x+1][y-1]
  if (x > 0) and (y < maxy): ret += plane[x-1][y+1]

  if plane[x][y] == 1:
    return -1
  else:
    return ret

# najde pole, ktere souvisi z 0 minami
# jinak vrati [-1, -1]
def find_zero(neighbors):
    width = len(neighbors)
    height = len(neighbors[0])

    for i in range(width):
      for j in range(height):
        if (neighbors[i][j] == 0):
          return [i, j]
    return [-1, -1]
  

# tato funkce "navstivi" bod - sebere ho z fronty, zapamtuje si, ze ho uz navstivila, a jeho sousedy prida na konec fronty
def mark_pos(pos, queue, neighbors):  
  x = pos[0]
  y = pos[1]
  maxx = len(neighbors)-1
  maxy = len(neighbors[0])-1  

  # ukoncovaci podminka: pokud policko neobsahuje 0, oznacim ho za navstivene a dale ho neexpanduji
  if (neighbors[x][y] != 0):
    neighbors[x][y] = -1
    return
  
  neighbors[x][y] = -1

  if (x > 0): queue.put([x-1, y])
  if (y > 0): queue.put([x, y-1])
  if (x < maxx): queue.put([x+1, y])
  if (y < maxy): queue.put([x, y+1])

  if (x < maxx) and (y < maxy): queue.put([x+1, y+1])
  if (x > 0) and (y > 0): queue.put([x-1, y-1])
  if (x < maxx) and (y > 0): queue.put([x+1, y-1])
  if (x > 0) and (y < maxy): queue.put([x-1, y+1])

# prohledavani do sirky
# tato funkce kompletne expanduje vrchol pos ([x, y])
def expand_point(pos, neighbors):
    q = Queue.Queue()
    q.put(pos)
    while (not q.empty()):
      pos = q.get();
      mark_pos(pos, q, neighbors);

def optimal_minesweeper(plane):
    # Prace se souborem - otevre soubor clicks.txt k zapisu
    # Pozor, pokud subor jiz existuje prepise jeho obsah.
    file = open("clicks.txt", 'w')
    # Zde implementujte svuj algoritmus
    # Zapisujte jednotlive souradnice kliku do souboru
    # pomoci nasledujuciho prikazu file.write("%d %d\n"%(RADEK,SLOUPEC))
    # kde RADEK a SLOUPEC reprezentuji pozici kliknuti (%d je zapis
    # celeho cisla, ktere se vezme z promenne RADEK, resp. SLOUPEC)

    # sirka hraciho pole, vyska hraciho pole
    width = len(plane)
    height = len(plane[0])
    neighbors = [[0 for i in range(width)] for i in range(height)] # pocet sousednich min daneho vrcholu - 2D pole

    # 1) dopocteme pocet sousednich min pro kazde policko
    for i in range(width):
      for j in range(height):
        neighbors[i][j] = getcnt(i, j, plane)

    # 2) hledame nulove vrcholy, dokud jsou, a ty expandujeme do sirky:
    pos = find_zero(neighbors)
    while (pos[0] != -1):      
      file.write("%d %d\n"%(pos[0],pos[1]))
      expand_point(pos, neighbors)
      pos = find_zero(neighbors)

    # 3) ted jsou vsechny nulove vrcholy expandovane -> expanduji vsechny ostatni
    for i in range(width):
      for j in range(height):
        if (neighbors[i][j] > 0):
          file.write("%d %d\n"%(i, j))
        
    #Zavreni souboru
    file.close()
